Attribute VB_Name = "DAQ_34970"
Option Explicit
' This code was created by the 34970A Code Wizard
'
' Add the example code as a .bas module to your Visual
' Basic Project. Add the 3494A Control, and call
' the function 'main_34970A' with the control name
' as the argument.  (example; main_3497A <Name>)
 Sub main_34970A(DAQ_34970 As Agt3494A)
    Dim numberChannels As Integer
    Dim numberSweeps As Integer
    Dim Sweep As Integer
    Dim Readings() As Double
    Dim Units() As String
    Dim ChanNumb() As Integer
    Dim Time() As Date

    With DAQ_34970
        .Connect
        ' Set instrument to power on state
        .Output "*RST"
    End With
    
    Configure_34970A DAQ_34970
    
    SetScan_34970A DAQ_34970, numberSweeps, numberChannels
    
    ' Size arrays depending on channel and sweep count
    ReDim Readings(numberSweeps, numberChannels)
    ReDim Units(numberSweeps, numberChannels)
    ReDim ChanNumb(numberSweeps, numberChannels)
    ReDim Time(numberSweeps, numberChannels)
    ' Get data one sweep at a time
    For Sweep = 1 To numberSweeps
        ReadData_34970A DAQ_34970, Sweep, numberChannels, Readings(), _
                Units(), ChanNumb(), Time()

        '#########################################################
        ' This code was added after the Wizard added this module
        frmScanner.WriteDataToForm Readings, Units, ChanNumb, Time, Sweep, numberChannels
        '#########################################################

    Next Sweep
End Sub
 Sub Configure_34970A(Instrument As Agt3494A)
    With Instrument
        ' Configure all channels in channel list
        ' Channels 101   Volts DC    Auto    4  digits
        .Output "Conf:volt:DC Auto,(@101);:Volt:DC:NPLC 0.02,(@101)"
        ' Channels 107   Resistance  Auto    4  digits
        .Output "Conf:Res Auto,(@107);:Res:NPLC 0.02,(@107)"
        ' Channels 110   Volts DC    Auto    4  digits
        .Output "Conf:volt:DC Auto,(@110);:Volt:DC:NPLC 0.02,(@110)"
        ' Channels 112   Temperature TC  J type  C
        .Output "Conf:Temp TC,J,(@112);:Unit:Temp C,(@112)"
    End With
End Sub
 Sub SetScan_34970A(Instrument As Agt3494A, numberSweeps As Integer, numberChannels As Integer)
    Dim replyString As String

    numberSweeps = 5
    With Instrument
        ' Include the Measurement units with reading
        .Output "Format:Reading:Unit On"
        ' Include the channel with reading
        .Output "Format:Reading:Channel On"
        ' Include the time with reading
        .Output "Format:Reading:Time On"
        ' Set up the scan List
        .Output "Route:Scan (@101,107,110,112)"
        ' Configure the trigger source
        .Output "Trigger:Source Timer"
        ' Set the time between scans
        .Output "Trigger:Timer 1"
        ' Set the number of scans
        .Output "Trigger:Count " & Str$(numberSweeps)
        ' Read the number of channels on scan list
        .Output "Route:Scan:Size?"
        .Enter replyString
        numberChannels = Val(replyString)
        ' Arm the trigger with initiate
        .Output "Initiate"
    End With
End Sub
 Sub ReadData_34970A(Instrument As Agt3494A, Sweeps As Integer, numberChannels As Integer, _
         Readings() As Double, _
         Units() As String, ChanNumb() As Integer, Time() As Date)
    Dim Points As Integer
    Dim channel As Integer
    Dim replyString As String

    With Instrument
        ' Get the data one channel at a time
        For channel = 1 To numberChannels
            ' Wait for reading in instrument memory
            Do
                .Output "Data:Points?"
                .Enter replyString
                Points = CInt(replyString)
            Loop Until Points >= 1
            ' Get one channel of data from instrument
            .Output "Data:Remove? 1"
            .Enter replyString
            ' Remove the reading data from string
            Readings(Sweeps, channel) = CDbl(Mid$(replyString, 1, 15))
            ' Remove the units data from string
            Units(Sweeps, channel) = Mid$(replyString, 17, 3)
            ' Remove the time data from string
            Time(Sweeps, channel) = Val(Mid$(replyString, 21, 12)) / 86400
            ' Remove the channel number from string
            ChanNumb(Sweeps, channel) = Val(Mid$(replyString, 34, 3))
        Next channel
    End With
End Sub


